/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ArmorNobleModifier
extends Modifier
implements AttributesModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<Integer> NOBLE = TConstruct.createKey((String)"noble");

    public ArmorNobleModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorNobleModifier::onApplyEffect);
    }

    private static void onApplyEffect(MobEffectEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            MobEffectInstance instance;
            int level = (Integer)holder.get(NOBLE, (Object)0);
            if (level > 0 && living instanceof ServerPlayer && event.getEffectInstance() != null && (instance = event.getEffectInstance()).m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                if (instance.m_19564_() + 1 <= level) {
                    event.setResult(Event.Result.DENY);
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                } else {
                    event.getEffectInstance().m_19558_(new MobEffectInstance(instance.m_19544_(), (int)Math.max(5.0f, (1.0f - 0.2f * (float)level) * (float)instance.m_19557_()), instance.m_19564_() - level));
                }
            }
        });
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        consumer.accept(Attributes.f_22286_, new AttributeModifier(UUID.fromString("8ece3973-02f0-459e-a5d1-4cda8209f161"), Attributes.f_22286_.m_22087_(), (double)modifier.getLevel(), AttributeModifier.Operation.ADDITION));
    }
}

